<?php

use Illuminate\Http\Request;
use App\Http\Controllers\HomeController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
// use App\Http\Controllers\API\AdminController;
use App\Http\Controllers\SalonController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\WishlistController;
use App\Http\Controllers\API\SalonBookingController;
use App\Http\Controllers\AppointmentController;
use App\Http\Controllers\StaffController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\ShippingDetailController;
use App\Http\Controllers\PaymentOptionController;
use App\Http\Controllers\OrderConfirmationController;
use App\Http\Controllers\OrderController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\TeamMemberController;
use App\Http\Controllers\BeauticianController;
use App\Http\Controllers\BeauticianSkillController;
use App\Http\Controllers\ExpertiseController;
use App\Http\Controllers\QualificationController;
use App\Http\Controllers\ExperienceController;
use App\Http\Controllers\ProfileSettingController;
use App\Http\Controllers\PortfolioSettingController;
use App\Http\Controllers\BeauticianAvailabilityController;
use App\Http\Controllers\BeauticianServiceController;
use App\Http\Controllers\ContactNumberController;
use App\Http\Controllers\BeauticianReviewController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\BeauticianPortfolioController;
use App\Http\Controllers\BeauticianClientPictureController;
use App\Http\Controllers\BeauticianOrderController;
use App\Http\Controllers\BeauticianOrderStatsController;
use App\Http\Controllers\BeauticianCustomerDetailController;
use App\Http\Controllers\GetBookingSalesOverview;
use App\Http\Controllers\ChatController;
use Illuminate\Support\Facades\Broadcast;
use App\Http\Controllers\AdminReportController;






/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
//     return $request->user();
// });

// Route::post('/register', [AuthController::class, 'register']);

// Route::post('/register', [AuthController::class, 'register']);
// Route::post('/login', [AuthController::class, 'login']);

Route::post('/register', [AuthController::class, 'register']);
// Route::post('/login', [AuthController::class, 'login']);
Route::post('/login', [AuthController::class, 'login'])->name('login');

Route::middleware('auth:sanctum')->group(function () {
    Route::post('/logout', [AuthController::class, 'logout']);
    // Route::get('/profile', [AuthController::class, 'profile']);
});




Route::post('/forgot-password', [ForgotPasswordController::class, 'sendResetLink']);
Route::get('/reset-password/{token}', function ($token) {
    return view('auth.passwords.reset', ['token' => $token]);
})->name('password.reset');

Route::middleware('auth:sanctum')->get('/profile', [ProfileController::class, 'getProfile']);
Route::middleware('auth:sanctum')->post('/update-profile', [ProfileController::class, 'updateProfile']);



// Home screen
Route::get('/home', [HomeController::class, 'index']);
// Salon details
Route::get('/salons/{id}', [SalonController::class, 'show']);
Route::delete('/salons/{id}', [SalonController::class, 'destroy']);
// Route::get('/salon/{id}', [SalonController::class, 'salonDetail']);
Route::post('/salons', [SalonController::class, 'store']);

Route::put('/salons/{id}', [SalonController::class, 'update']);



Route::get('/salon-details', [HomeController::class, 'salonDetails']);


Route::get('/products/{id}', [ProductController::class, 'show']);
Route::get('/products/popular', [ProductController::class, 'popularProducts']);
Route::get('/products/similar/{id}', [ProductController::class, 'similarProducts']);
Route::get('/products/search', [ProductController::class, 'search']);
Route::post('/wishlist/add', [ProductController::class, 'addToWishlist']);




Route::middleware('auth:sanctum')->group(function () {
    Route::get('/wishlist', [WishlistController::class, 'index']);
    Route::post('/wishlist/toggle', [WishlistController::class, 'toggleWishlist']);
});


Route::post('/get-available-staff', [SalonBookingController::class, 'getAvailableStaff']);

Route::post('/book-appointment', [AppointmentController::class, 'book']);
Route::get('/staff-list', [StaffController::class, 'index']);
Route::post('/appointments', [AppointmentController::class, 'store']);
Route::put('/appointments/{id}/confirm', [AppointmentController::class, 'confirm']);
Route::put('/appointments/{id}/cancel', [AppointmentController::class, 'cancel']);
Route::post('/appointments', [AppointmentController::class, 'book']);
Route::get('/appointments/{id}', [AppointmentController::class, 'show']);

Route::get('/appointments', [AppointmentController::class, 'listAppointments']);



// Route::prefix('cart')->group(function () {
//     Route::get('/', [CartController::class, 'index']); // Get cart items
//     Route::post('/add', [CartController::class, 'add']); // Add product to cart
//     Route::delete('/remove/{id}', [CartController::class, 'remove']); // Remove product
//     Route::post('/select/{id}', [CartController::class, 'selectForCheckout']); // Select for checkout
//     Route::post('/increase/{id}', [CartController::class, 'increaseQuantity']); // Increase quantity
//     Route::post('/decrease/{id}', [CartController::class, 'decreaseQuantity']); // Decrease quantity
//     Route::post('/buy/{id}', [CartController::class, 'buyNow']); // Buy now
// });

Route::get('/cart', [CartController::class, 'index']); // View cart
Route::post('/cart/add', [CartController::class, 'addToCart']);
Route::post('/cart/remove', [CartController::class, 'removeFromCart']);
Route::post('/cart/update', [CartController::class, 'updateCart']);



Route::get('/shipping-details', [ShippingDetailController::class, 'index']); // Get all
Route::post('/shipping-details', [ShippingDetailController::class, 'store']); // Create
Route::get('/shipping-details/{id}', [ShippingDetailController::class, 'show']); // Get by ID



Route::get('/payment-options', [PaymentOptionController::class, 'index']);
Route::post('/payment-options', [PaymentOptionController::class, 'store']);

// Route::middleware('auth:sanctum')->group(function () {
//     Route::post('/payment-options', [PaymentOptionController::class, 'store']);
//     Route::get('/payment-options', [PaymentOptionController::class, 'index']);
// });

Route::post('/order-confirmation', [OrderConfirmationController::class, 'store']);
Route::get('/track-order/{order_id}', [OrderConfirmationController::class, 'trackOrder']);
Route::put('/update-status/{order_id}', [OrderConfirmationController::class, 'updateStatus']);



// Route::middleware('auth:sanctum')->group(function () {
//     Route::get('/orders', [OrderController::class, 'index']);
// });
Route::get('/orders', [OrderController::class, 'index']);



Route::get('/appointments/{id}', [AppointmentController::class, 'show']);

// Route::middleware('auth:sanctum')->get('/my-orders', [OrderController::class, 'myOrders']);
Route::post('/orders', [OrderController::class, 'store']);


Route::get('/team-members', [TeamMemberController::class, 'index']);
Route::post('/team-members', [TeamMemberController::class, 'store']);
Route::put('/team-members/{teamMember}', [TeamMemberController::class, 'update']);
Route::delete('/team-members/{teamMember}', [TeamMemberController::class, 'destroy']);


Route::post('/register-admin', [AuthController::class, 'registerAdmin']);
Route::post('/admin/login', [AuthController::class, 'adminLogin']);

Route::middleware(['auth:sanctum', 'admin'])->group(function () {
    Route::post('/team-members', [TeamMemberController::class, 'store']);
    Route::put('/team-members/{id}', [TeamMemberController::class, 'update']);
    Route::delete('/team-members/{id}', [TeamMemberController::class, 'destroy']);
});


Route::post('/register-beautician-saba', [AuthController::class, 'registerBeautician']);
Route::post('/login-beautician', [AuthController::class, 'loginBeautician']);

Route::middleware(['auth:sanctum'])->group(function () {
    Route::get('/beautician/profile', [BeauticianController::class, 'profile']);
});


Route::middleware('auth:sanctum')->group(function () {
    Route::post('/beautician/skills', [BeauticianSkillController::class, 'addSkill']);
    Route::get('/beautician/skills', [BeauticianSkillController::class, 'viewSkills']);
    Route::put('/beautician/skills/{id}', [BeauticianSkillController::class, 'updateSkill']);
    Route::delete('/beautician/skills/{id}', [BeauticianSkillController::class, 'deleteSkill']);
});

Route::middleware('auth:sanctum')->group(function () {
    Route::post('/beautician/expertise', [ExpertiseController::class, 'store']); // Add expertise
    Route::get('/beautician/expertises', [ExpertiseController::class, 'index']); // View all expertise
    Route::put('/beautician/expertise/{id}', [ExpertiseController::class, 'update']); // Update expertise
    Route::delete('/beautician/expertise/{id}', [ExpertiseController::class, 'destroy']); // Delete expertise
});

Route::middleware('auth:sanctum')->group(function () {
    Route::post('/beautician/qualifications', [QualificationController::class, 'addQualification']);
    Route::get('/beautician/qualifications', [QualificationController::class, 'viewQualifications']);
    Route::put('/beautician/qualifications/{id}', [QualificationController::class, 'updateQualification']);
    Route::delete('/beautician/qualifications/{id}', [QualificationController::class, 'deleteQualification']);
});



Route::middleware('auth:sanctum')->group(function () {
    Route::get('/beautician/experiences', [ExperienceController::class, 'index']);
    Route::post('/beautician/experiences', [ExperienceController::class, 'store']);
    Route::put('/beautician/experiences/{id}', [ExperienceController::class, 'update']);
    Route::delete('/beautician/experiences/{id}', [ExperienceController::class, 'destroy']);
});




Route::middleware('auth:sanctum')->group(function () {
    Route::get('/beautician/profile/visibility', [ProfileSettingController::class, 'getVisibility']);
    Route::post('/beautician/profile/visibility', [ProfileSettingController::class, 'updateVisibility']);
});


Route::middleware('auth:sanctum')->group(function () {
    Route::get('/beautician/portfolio-visibility', [PortfolioSettingController::class, 'show']);
    Route::post('/beautician/portfolio-visibility', [PortfolioSettingController::class, 'update']);
});

Route::middleware('auth:sanctum')->group(function () {
    Route::apiResource('beautician/availabilities', BeauticianAvailabilityController::class)->only(['index', 'store', 'destroy']);
    Route::get('beautician-services', [BeauticianServiceController::class, 'index']); // Get offered services
    Route::post('beautician-services', [BeauticianServiceController::class, 'store']); // Add a service
    Route::delete('beautician-services/{id}', [BeauticianServiceController::class, 'destroy']); // Delete a service
    Route::get('available-services', [BeauticianServiceController::class, 'availableServices']); // Get available services

});

Route::middleware('auth:sanctum')->group(function () {
    Route::get('beautician/profile/view-phone', [ContactNumberController::class, 'showProfile']);
    Route::put('beautician/profile/update-phone', [ContactNumberController::class, 'updatePhone']);
    Route::delete('beautician/profile/delete-phone', [ContactNumberController::class, 'deletePhone']);
});

Route::get('/beautician/{id}/profile', [BeauticianReviewController::class, 'showProfile']);

Route::middleware('auth:sanctum')->group(function () {
    // Get notifications for a specific beautician
    Route::get('/beautician/{beauticianId}/notifications', [NotificationController::class, 'getNotifications']);

    // Mark notification as read
    Route::put('/notifications/{id}/mark-as-read', [NotificationController::class, 'markAsRead']);

    // Create a new notification (for review or order request)
    Route::post('/notifications', [NotificationController::class, 'createNotification']);
});



 Route::middleware('auth:sanctum')->group(function () {
    Route::get('/beautician/{id}/portfolio', [BeauticianPortfolioController::class, 'index']);
    Route::post('/beautician/portfolio', [BeauticianPortfolioController::class, 'store']);
    Route::post('/beautician/{id}/portfolio/update', [BeauticianPortfolioController::class, 'update']);
    Route::delete('/beautician/{id}/portfolio/delete', [BeauticianPortfolioController::class, 'destroy']);
});

Route::prefix('beautician')->group(function () {
    Route::get('{beautician_id}/client-pictures', [BeauticianClientPictureController::class, 'index']);
    Route::post('client-pictures', [BeauticianClientPictureController::class, 'store']);
    Route::post('client-pictures/{id}/update', [BeauticianClientPictureController::class, 'update']);
    Route::delete('client-pictures/{id}', [BeauticianClientPictureController::class, 'destroy']);
});


Route::middleware('auth:sanctum')->prefix('beautician')->group(function () {
    Route::post('orders', [BeauticianOrderController::class, 'store']); // Create a new order
    Route::get('orders', [BeauticianOrderController::class, 'index']);   // List orders
    Route::post('orders/{id}/accept', [BeauticianOrderController::class, 'accept']); // Accept order
    Route::post('orders/{id}/reject', [BeauticianOrderController::class, 'reject']); // Reject order
    Route::get('beautician/{id}/order-stats', [BeauticianOrderStatsController::class, 'stats']);

});


Route::get('orders/{order_id}/customer-details', [BeauticianCustomerDetailController::class, 'showCustomerDetails']);


Route::middleware('auth:sanctum')->group(function () {
    Route::post('/admin/verify-user/{id}', [AuthController::class, 'verifyUser']);
    Route::get('/admin/unverified-users', [AuthController::class, 'unverifiedUsers']);

    Route::get('/messages', [ChatController::class, 'fetchMessages']);
    Route::post('/send-message', [ChatController::class, 'sendMessage']);
    Broadcast::routes(['middleware' => ['auth:sanctum']]);

    Route::get('/admin/reports/overview', [AdminReportController::class, 'overview']);
    Route::get('/admin/reports/export/{type}', [AdminReportController::class, 'exportReport']);

});

Route::get('/product-sales', [OrderController::class, 'getProductSales'])->middleware('auth:sanctum');
Route::get('/booking-sales-overview', [GetBookingSalesOverview::class, 'getBookingSalesOverview']);

// Route::get('/messages', [ChatController::class, 'fetchMessages']);
// Route::post('/send-message', [ChatController::class, 'sendMessage']);
// Broadcast::routes(['middleware' => ['auth:sanctum']]);

// ------------ Admin --------------------

// Route::middleware('auth:sanctum')->prefix('admin')->group(function () {
//     Route::get('/users', [AdminController::class, 'getUsers']);
//     Route::post('/users/{id}/update-status', [AdminController::class, 'updateUserStatus']);
// });

// Route::middleware('auth:sanctum')->prefix('admin')->group(function () {
//     Route::get('/bookings', [AdminController::class, 'getBookings']);
//     Route::get('/sales-overview', [AdminController::class, 'getSalesOverview']);
// });


// ------------ Admin  End --------------------
