<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Register</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0-alpha1/dist/css/bootstrap.min.css">
    <style>
        body {
            background: linear-gradient(rgba(0, 0, 0, 0.7),
                    rgba(0, 0, 0, 0.7)),
                url("{{ asset('Images/bg-19.png') }}");
            background-size: cover;
            background-position: center;
            font-family: Arial, sans-serif;
            color: white;
        }

        .container {
            margin-top: 80px;
        }

        .card {
            background-color: rgba(255, 255, 255, 0.9);
            border-radius: 15px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.3);
        }

        .card-header {
            font-size: 24px;
            font-weight: bold;
            text-align: center;
            background-color: #d9534f;
            color: white;
            border-radius: 15px 15px 0 0;
        }

        .form-control {
            border-radius: 10px;
        }

        .btn-[#E80000] {
            background-color: #d9534f;
            border: none;
            transition: 0.3s ease;
        }

        .btn-[#E80000]:hover {
            background-color: #c9302c;
        }

        .col-form-label {
            color: black;
            font-weight: bold;
        }

        footer {
            margin-top: 50px;
            text-align: center;
            color: white;
            font-size: 14px;
        }
    </style>
</head>

<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card">
                    <div class="card-header">{{ __('Register') }}</div>
                    <div class="card-body">
                        <form method="POST" action="{{ route('register') }}">
                            @csrf
                            <div class="mb-3 row">
                                <label for="name"
                                    class="col-md-4 col-form-label text-md-end">{{ __('Name') }}</label>
                                <div class="col-md-8">
                                    <input id="name" type="text"
                                        class="form-control @error('name') is-invalid @enderror" name="name"
                                        value="{{ old('name') }}" required autocomplete="name" autofocus>
                                    @error('name')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="email"
                                    class="col-md-4 col-form-label text-md-end">{{ __('Email Address') }}</label>
                                <div class="col-md-8">
                                    <input id="email" type="email"
                                        class="form-control @error('email') is-invalid @enderror" name="email"
                                        value="{{ old('email') }}" required autocomplete="email">
                                    @error('email')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>



                            @if (session('cart'))
                                @foreach (session('cart') as $id => $details)
                                    @if ($details['type'] == 'Course')
                                     
                                    <input id="email" type="hidden"
                                    class="form-control"
                                    name="roles[]"
                                    value="@if($details['category'] == 'Official') Official
                                           @elseif($details['category'] == 'Fighter') Fighter
                                           @elseif($details['category'] == 'Trainer') Trainer
                                           @else Unknown
                                           @endif">

                                    @else
                                        <div class="mb-3 row">
                                            <label for="roles"
                                                class="col-md-4 col-form-label text-md-end">{{ __('Roles') }}</label>
                                            <div class="col-md-8">
                                                <select
                                                    class="form-control rolestyle @error('roles') is-invalid @enderror"
                                                    multiple aria-label="Roles" id="roles" name="roles[]">
                                                    <option disabled selected>Select roles</option>
                                                    @foreach ($roles as $role)
                                                        <option value="{{ $role }}"
                                                            {{ in_array($role, old('roles') ?? []) ? 'selected' : '' }}>
                                                            {{ $role }}
                                                        </option>
                                                    @endforeach
                                                </select>
                                                @error('roles')
                                                    <span class="text-danger small">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    @endif
                                @endforeach
                            @endif







                            <div class="mb-3 row">
                                <label for="password"
                                    class="col-md-4 col-form-label text-md-end">{{ __('Password') }}</label>
                                <div class="col-md-8">
                                    <input id="password" type="password"
                                        class="form-control @error('password') is-invalid @enderror" name="password"
                                        required autocomplete="new-password">
                                    @error('password')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>

                            <div class="mb-3 row">
                                <label for="password-confirm"
                                    class="col-md-4 col-form-label text-md-end">{{ __('Confirm Password') }}</label>
                                <div class="col-md-8">
                                    <input id="password-confirm" type="password" class="form-control"
                                        name="password_confirmation" required autocomplete="new-password">
                                </div>
                            </div>

                            <div class="mb-0 row">
                                <div class="col-md-8 offset-md-4">
                                    <button type="submit" class="mb-3 btn btn-[#E80000] w-100">
                                        {{ __('Register') }}
                                    </button>
                                    <a class="btn btn-[#E80000] w-100" href="{{ route('login') }}">
                                        {{ __('Already have an account? Login') }}
                                    </a>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <footer>
        &copy; 2024 Boxsafe | All Rights Reserved
    </footer>
</body>

</html>
