<!DOCTYPE html>
<html>
<head>
    <title>Admin Report</title>
    <style>
        body { font-family: sans-serif; font-size: 14px; }
        h2 { margin-top: 30px; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        table, th, td { border: 1px solid #000; }
        th, td { padding: 8px; text-align: left; }
    </style>
</head>
<body>
    <h1>Admin Report</h1>

    @foreach ($users as $label => $val)
        <h2>User - {{ ucwords(str_replace('_', ' ', $label)) }}</h2>
        <p>{{ $val }}</p>
    @endforeach

    @foreach ($beauticians as $label => $val)
        <h2>Beautician - {{ ucwords(str_replace('_', ' ', $label)) }}</h2>
        <p>{{ $val }}</p>
    @endforeach

    @foreach ($earnings as $label => $val)
        <h2>Earnings - {{ ucwords(str_replace('_', ' ', $label)) }}</h2>
        <p>${{ number_format($val, 2) }}</p>
    @endforeach

    @foreach ($system_performance as $label => $val)
        <h2>Performance - {{ ucwords(str_replace('_', ' ', $label)) }}</h2>
        <p>{{ is_array($val) || is_object($val) ? json_encode($val) : $val }}</p>
    @endforeach

</body>
</html>
