<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Real-time Chat</title>
    <script src="https://cdn.jsdelivr.net/npm/pusher-js@7.0.3/dist/web/pusher.min.js"></script>
</head>
<body>

    <div id="chat">
        <!-- Your chat UI here -->
        <ul id="messages-list">
            <!-- Messages will be appended here -->
        </ul>
        <input type="text" id="message-input" placeholder="Type a message">
        <button onclick="sendMessage()">Send</button>
    </div>

    <script src="{{ mix('js/app.js') }}"></script>

    <script>
        // Assuming you have a 'userId' variable available for the authenticated user
        const userId = "{{ auth()->user()->id }}";

        Echo.private(`chat.${userId}`)
            .listen('MessageSent', (e) => {
                console.log('New message received:', e.message);
                // Append to the message list
                const messageList = document.getElementById('messages-list');
                const messageItem = document.createElement('li');
                messageItem.textContent = `${e.message.sender_id}: ${e.message.message}`;
                messageList.appendChild(messageItem);
            });

        function sendMessage() {
            const messageInput = document.getElementById('message-input');
            const message = messageInput.value;
            // Call your API to send the message here
        }
    </script>
</body>
</html>
