<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Salon;
use App\Models\Service;
use App\Models\DemoVideo;

class SalonSeeder extends Seeder
{
    public function run()
    {
        // Create salons
        $salon1 = Salon::create([
            'name' => 'Luxury Beauty Salon',
            'rating' => 4.8,
            'reviews' => 150,
            'price' => 5000,
            'discount' => 20,
            'open_time' => '08:00:00', // Added open_time
            'close_time' => '22:00:00', // Added close_time
        ]);

        $salon2 = Salon::create([
            'name' => 'Elite Hair Studio',
            'rating' => 4.5,
            'reviews' => 120,
            'price' => 3500.0,
            'discount' => 15,
            'open_time' => '09:00:00', // Added open_time
            'close_time' => '21:00:00', // Added close_time
        ]);

        // Create demo videos
        DemoVideo::create([
            'salon_id' => $salon1->id,
            'video_url' => 'https://example.com/luxury-salon.mp4'
        ]);

        DemoVideo::create([
            'salon_id' => $salon2->id,
            'video_url' => 'https://example.com/elite-hair.mp4'
        ]);

        // Create services
        Service::create([
            'salon_id' => $salon1->id,
            'name' => 'Haircut & Styling',
            'rating' => 4.7,
            'reviews' => 100,
            'price' => 1500.0,
            'discount' => 10
        ]);

        Service::create([
            'salon_id' => $salon2->id,
            'name' => 'Facial Treatment',
            'rating' => 4.6,
            'reviews' => 80,
            'price' => 2000.0,
            'discount' => 5
        ]);
    }
}
