<?php

namespace Database\Seeders;

use App\Models\Review;
use App\Models\User;
use Illuminate\Database\Seeder;
use Faker\Factory as Faker;

class ReviewSeeder extends Seeder
{
    public function run()
    {
        $faker = Faker::create();

        // Ensure you are only creating reviews for beauticians
        $beauticians = User::where('role', 'beautician')->get(); // Only beauticians
        foreach ($beauticians as $beautician) {
            // Only create 5 reviews for each beautician
            foreach (range(1, 5) as $index) {
                Review::create([
                    'beautician_id' => $beautician->id,
                    'user_id' => User::inRandomOrder()->first()->id, // Random user giving the review
                    'rating' => $faker->numberBetween(1, 5),
                    'comment' => $faker->sentence,
                ]);
            }
        }
    }
}
