<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class ProductSeeder extends Seeder {
    public function run() {
        DB::table('products')->insert([
            [
                'name' => 'Shampoo',
                'rating' => 4.5,
                'reviews' => 120,
                'price' => 499.99,
                'description' => 'A nourishing shampoo for all hair types.',
                'size' => '250ml',
                'size_options' => json_encode(['250ml', '500ml']),
                'images' => json_encode(['shampoo1.jpg', 'shampoo2.jpg']),
                'category_id' => 1,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
            [
                'name' => 'Face Wash',
                'rating' => 4.2,
                'reviews' => 80,
                'price' => 299.99,
                'description' => 'A deep cleansing face wash with aloe vera.',
                'size' => '150ml',
                'size_options' => json_encode(['150ml', '300ml']),
                'images' => json_encode(['facewash1.jpg', 'facewash2.jpg']),
                'category_id' => 2,
                'created_at' => Carbon::now(),
                'updated_at' => Carbon::now(),
            ],
        ]);
    }
}
