<?php

namespace Database\Seeders;

use App\Models\Order;
use App\Models\User;
use Illuminate\Database\Seeder;

class OrderSeeder extends Seeder {
    public function run() {
        $user = User::first(); // Assigning orders to first user

        Order::create([
            'user_id' => $user->id,
            'item_name' => 'Perfume X',
            'quantity' => 2,
            'type' => '100ml',
            'price' => 1200.50,
            'status' => 'to_pay'
        ]);

        Order::create([
            'user_id' => $user->id,
            'item_name' => 'Face Cream',
            'quantity' => 1,
            'type' => '50g',
            'price' => 800.00,
            'status' => 'to_receive'
        ]);

        Order::create([
            'user_id' => $user->id,
            'item_name' => 'Shampoo Y',
            'quantity' => 3,
            'type' => '200ml',
            'price' => 1500.00,
            'status' => 'to_review'
        ]);
    }
}

