<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\OrderConfirmation;
use Illuminate\Support\Str;

class OrderConfirmationSeeder extends Seeder
{
    public function run()
    {
        OrderConfirmation::create([
            'order_id' => strtoupper(Str::random(10)),
            'order_date' => now()->format('Y-m-d'),
            'expected_delivery_date' => now()->addDays(5)->format('Y-m-d'),
            'track_order_url' => url('/api/track-order/' . strtoupper(Str::random(10))),
        ]);
    }
}

