<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */


     public function up()
     {
             Schema::create('services', function (Blueprint $table) {
             $table->id();
           // salon details
             $table->foreignId('salon_id')->constrained()->onDelete('cascade');
             // salon details
             $table->string('name');
             $table->integer('discount_percentage')->default(0);
            $table->decimal('rating', 2, 1)->default(0);
            $table->integer('reviews')->default(0);
            $table->decimal('price', 8, 2);
            $table->integer('likes')->default(0);
            $table->timestamps();
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('services');
    }
};
