<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReviewsTable extends Migration
{
    // public function up()
    // {
    //     Schema::create('reviews', function (Blueprint $table) {
    //         $table->id();
    //         $table->foreignId('beautician_id')->constrained('users')->index();  // Add index for better lookup performance
    //         $table->foreignId('user_id')->constrained('users')->index();        // Add index for better lookup performance
    //         $table->integer('rating');
    //         $table->text('comment')->nullable();
    //         $table->timestamps();
    //     });
    // }


    public function up()
{
    Schema::create('reviews', function (Blueprint $table) {
        $table->id();
        $table->foreignId('beautician_id')->constrained('users')->index()->onDelete('cascade')->name('fk_beautician_id');
        $table->foreignId('user_id')->constrained('users')->index()->onDelete('cascade')->name('fk_user_id');
        $table->integer('rating');
        $table->text('comment')->nullable();
        $table->timestamps();
    });
}


    public function down()
    {
        Schema::dropIfExists('reviews');
    }
}
