<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBeauticianOrdersListTable extends Migration
{
    public function up()
    {
        Schema::create('beautician_orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users'); // link to beautician
            $table->string('item_name');
            $table->integer('quantity');
            $table->string('type');  // e.g., service type
            $table->decimal('price', 8, 2);
            $table->enum('status', ['pending', 'accepted', 'rejected'])->default('pending');
            $table->timestamps();
        });
    }

    public function down()
    {
        Schema::dropIfExists('beautician_orders');
    }
}
