<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('beautician_client_pictures', function (Blueprint $table) {
            $table->id();
            $table->foreignId('beautician_id')->constrained('users')->onDelete('cascade');
            $table->string('title')->nullable();
            $table->string('image_path'); // for image file
            $table->timestamps();
        });
    }

    public function down(): void {
        Schema::dropIfExists('beautician_client_pictures');
    }
};

