<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateContactNumbersTable extends Migration
{
    public function up(): void
    {
        Schema::create('contact_numbers', function (Blueprint $table) {
            $table->id();
            $table->foreignId('beautician_id')->constrained('users')->onDelete('cascade');
            $table->string('contact_number');
            $table->timestamps();

            $table->unique(['beautician_id', 'contact_number']); // Ensuring a beautician has unique contact numbers
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('contact_numbers');
    }
}
