<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('beautician_availabilities', function (Blueprint $table) {
            $table->id();
            $table->foreignId('beautician_id')->constrained('users')->onDelete('cascade');
            $table->date('available_date');
            $table->time('start_time');
            $table->time('end_time');
            $table->timestamps();

            // Define a shorter unique index name
            $table->unique(['beautician_id', 'available_date', 'start_time', 'end_time'], 'beautician_avail_unique');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('beautician_availabilities');
    }
};
