<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up() {
        if (!Schema::hasTable('users')) {
            throw new \Exception('Users table must be created before orders table.');
        }

        Schema::create('orders', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained('users')->onDelete('cascade');
            $table->string('item_name');
            $table->integer('quantity');
            $table->string('type'); // e.g., 100ml
            $table->unsignedDecimal('price', 10, 2);
            // $table->enum('status', ['to_pay', 'to_receive', 'to_review']);
            $table->enum('status', ['to_pay', 'to_receive', 'to_review', 'completed', 'cancelled']);
            $table->timestamps();
        });
    }

    public function down() {
        Schema::dropIfExists('orders');
    }
};
