<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
    {
        Schema::create('order_confirmations', function (Blueprint $table) {
            $table->id();
            $table->string('order_id')->unique(); // Unique Alphanumeric Order ID
            $table->date('order_date'); // Order Date
            $table->date('expected_delivery_date'); // Expected Delivery Date
            $table->string('confirmation_message')->default('Your order has been successfully confirmed!'); // Message
            $table->string('track_order_url'); // Track Order URL
            $table->enum('status', ['Pending', 'Processing', 'Shipped', 'Delivered', 'Cancelled'])->default('Pending'); // Order Status

            $table->timestamps();
        });
    }


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('order_confirmations');
    }
};
