<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
{
    Schema::create('payment_options', function (Blueprint $table) {
        $table->id();
        $table->foreignId('user_id')->constrained()->onDelete('cascade');
        $table->string('payment_method');
        $table->decimal('amount', 10, 2);
        $table->string('currency');
        $table->text('description')->nullable();

        // Credit Card (encrypted fields)
        $table->text('card_number')->nullable();
        $table->text('expiry_date')->nullable();
        $table->text('cvv')->nullable();

        // Mobile Wallet
        $table->string('mobile_number')->nullable();
        $table->string('transaction_id')->nullable();

        // Bank Transfer
        $table->string('bank_name')->nullable();
        $table->text('account_number')->nullable();

        $table->timestamps();
    });

}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('payment_options');
    }
};
