<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up()
{
    Schema::create('salons', function (Blueprint $table) {
        $table->id();
        $table->string('name');
        $table->string('location');
        $table->decimal('rating', 2, 1)->default(0);
        $table->integer('reviews')->default(0);
        // $table->time('open_time');
        $table->time('open_time')->nullable();

        // $table->time('close_time');
        $table->time('close_time')->nullable();

        $table->decimal('price_min', 10, 2)->default(0);
        // $table->decimal('price_max', 8, 2);
        // $table->integer('price_max')->nullable()->default(0);

        $table->integer('discount')->default(0); // Discount in percentage
        $table->string('video_url')->nullable();
        $table->json('facilities')->nullable();
        $table->timestamps();
    });
}


    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('salons');
    }
};
