<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Service extends Model
{
    use HasFactory;
    protected $fillable = [
        'salon_id', 'name', 'discount_percentage', 'rating',
        'reviews', 'price', 'likes'
    ];

    public function salon()
    {
        return $this->belongsTo(Salon::class);
    }
    public function beauticianServices()
{
    return $this->hasMany(BeauticianService::class, 'service_id');
}
}
