<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Salon extends Model
{
    use HasFactory;
    protected $fillable = [
        'name', 'location', 'rating', 'reviews', 'open_time', 'close_time',
        'price', 'video_url', 'facilities'
    ];


    protected $casts = [
        'facilities' => 'array',
    ];

    public function services()
    {
        return $this->hasMany(Service::class);
    }

    public function wishlists()
{
    return $this->morphMany(Wishlist::class, 'wishlistable');
}


}
