<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Review extends Model
{
    use HasFactory;

    protected $fillable = [
        'beautician_id',
        'user_id',
        'rating',
        'comment',
    ];

    // Relationships
    public function beautician()
    {
        return $this->belongsTo(User::class, 'beautician_id');
    }

    public function reviewer()
    {
        return $this->belongsTo(User::class, 'user_id');
    }
}
