<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Qualification extends Model
{
    use HasFactory;

    protected $fillable = [
        'beautician_id',
        'qualification_name',
        'institute_name',
        'year_completed',
        'certificate_image'
    ];

    public function beautician()
    {
        return $this->belongsTo(User::class, 'beautician_id');
    }
}
