<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    use HasFactory;

    protected $fillable = [
        'beautician_id',
        'title',
        'message',
        'type',
        'is_read',
    ];

    // Define the relationship with the beautician (user)
    public function beautician()
    {
        return $this->belongsTo(User::class, 'beautician_id');
    }
}
