<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Experience extends Model
{
    use HasFactory;

    protected $fillable = [
        'beautician_id',
        'job_title',
        'company_name',
        'start_date',
        'end_date',
        'experience_description',
        'certificate_image'
    ];

    public function beautician()
    {
        return $this->belongsTo(User::class, 'beautician_id');
    }
}
