<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CartItem extends Model
{
    use HasFactory;

    protected $fillable = ['user_id', 'product_id', 'quantity', 'is_favorite'];

    protected $casts = [
        'is_favorite' => 'boolean', // Ensures it's always a boolean
    ];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    // Get the shareable product URL
    public function getShareUrlAttribute()
    {
        return url("/product/" . $this->product_id);
    }

    // Get the product details icon URL
    public function getIconUrlAttribute()
    {
        return url("/product/details/" . $this->product_id);
    }
}
