<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Appointment extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'username',
        'email',
        'phone_number',
        'appointment_type',
        'appointment_time',
        'services',
        'status',  // Ensure 'status' is included in the fillable array
        'appointment_date',
        'rating',
        'review',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
