<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'name' => $this->item_name, // Use 'item_name' as defined in migration
            'type' => $this->type,
            'status' => $this->mapStatus($this->status), // Convert status dynamically
            'price' => $this->price,
            'created_at' => $this->created_at->format('Y-m-d H:i:s'),
        ];
    }

    private function mapStatus($status)
    {
        $statusMap = [
            'to_pay' => 'Pending Payment',
            'to_receive' => 'Shipped',
            'to_review' => 'Delivered',
            'completed' => 'Completed',
            'cancelled' => 'Cancelled',
        ];

        return $statusMap[$status] ?? 'Unknown';
    }
}
