<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RememberMeMiddleware
{
    public function handle(Request $request, Closure $next)
    {
        $user = $request->user(); // Get the authenticated user

        if ($user) {
            // Fetch the user's current token
            $token = $user->tokens()->where('id', $request->user()->currentAccessToken()->id)->first();

            if ($token && $token->expires_at && now()->greaterThan($token->expires_at)) {
                $token->delete(); // Delete expired token
                return response()->json(['message' => 'Session expired. Please log in again.'], 401);
            }
        }

        return $next($request);
    }
}
