<?php

namespace App\Http\Controllers;

use App\Models\Appointment;
use Illuminate\Http\Request;
use App\Http\Requests;
use Illuminate\Support\Facades\DB;



class GetBookingSalesOverview extends Controller
{
    // Method inside the class
    public function getBookingSalesOverview(Request $request)
    {
        // Get the total number of appointments and total sales from orders
        $totalAppointments = Appointment::count();
        $totalSales = DB::table('orders')->where('status', 'to_pay')->sum(DB::raw('price * quantity'));

        // Get the booking details
        $appointments = Appointment::select(
                'appointments.id',
                'appointments.user_id',
                'appointments.username',
                'appointments.email',
                'appointments.phone_number',
                'appointments.appointment_type',
                'appointments.appointment_time',
                'appointments.services',
                'appointments.status',  // Updated status field
                'appointments.created_at',
                'appointments.updated_at',
                'appointments.appointment_date',
                'appointments.rating',
                'appointments.review'
            )
            ->latest()  // Sort by newest
            ->paginate(10);  // Pagination for top 10

        return response()->json([
            'status' => true,
            'message' => 'Booking and Sales Overview',
            'data' => [
                'total_appointments' => $totalAppointments,
                'total_sales' => $totalSales,
                'appointments' => $appointments,
            ]
        ]);
    }
}
