<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Wishlist;
use App\Models\Product;
use App\Models\Salon;
use App\Models\Brand;

class WishlistController extends Controller
{
    public function index(Request $request)
    {
        $user = $request->user();

        if (!$user) {
            return response()->json(['error' => 'Unauthorized'], 401);
        }

        $wishlist = Wishlist::where('user_id', $user->id)
            ->with('wishlistable')
            ->get()
            ->groupBy('wishlistable_type');

        return response()->json([
            'wishlist' => $wishlist
        ], 200, ['Content-Type' => 'application/json']);
    }


    public function toggleWishlist(Request $request)
    {
        $request->validate([
            'type' => 'required|in:product,salon,brand',
            'id'   => 'required|integer'
        ]);

        $user = $request->user();
        if (!$user) {
            return response()->json(['error' => 'Unauthorized'], 401);
        }

        $type = $request->type;
        $id = $request->id;

        $modelClass = [
            'product' => Product::class,
            'salon'   => Salon::class,
            'brand'   => Brand::class,
        ][$type];

        $wishlistItem = Wishlist::where([
            'user_id' => $user->id,
            'wishlistable_id' => $id,
            'wishlistable_type' => $modelClass
        ])->first();

        if ($wishlistItem) {
            $wishlistItem->delete();
            return response()->json(['message' => 'Removed from wishlist'], 200, ['Content-Type' => 'application/json']);
        } else {
            Wishlist::create([
                'user_id' => $user->id,
                'wishlistable_id' => $id,
                'wishlistable_type' => $modelClass
            ]);
            return response()->json(['message' => 'Added to wishlist'], 200, ['Content-Type' => 'application/json']);
        }
    }

}
