<?php

namespace App\Http\Controllers;

use App\Models\TeamMember;
use Illuminate\Http\Request;
use Illuminate\Http\Response;

class TeamMemberController extends Controller {
    // Fetch team members (Paginated)
    public function index() {
        return response()->json(TeamMember::paginate(10));
    }

    // Store a new team member
    public function store(Request $request) {
        $validated = $request->validate([
            'name' => 'required|string|max:255',
            'role' => 'required|string|max:255',
            'image_url' => 'required|url',
        ]);

        $teamMember = TeamMember::create($validated);
        return response()->json($teamMember, Response::HTTP_CREATED);
    }

    // Update a team member
    public function update(Request $request, TeamMember $teamMember) {
        $validated = $request->validate([
            'name' => 'sometimes|string|max:255',
            'role' => 'sometimes|string|max:255',
            'image_url' => 'sometimes|url',
        ]);

        $teamMember->update($validated);
        return response()->json($teamMember);
    }

    // Delete a team member
    public function destroy(TeamMember $teamMember) {
        $teamMember->delete();
        return response()->json(['message' => 'Team member deleted successfully'], Response::HTTP_NO_CONTENT);
    }
}
