<?php
namespace App\Http\Controllers;

use App\Models\ShippingDetail;
use Illuminate\Http\Request;

class ShippingDetailController extends Controller
{
    // Get all shipping details
    public function index()
    {
        $shippingDetails = ShippingDetail::all();
        return response()->json([
            'success' => true,
            'data' => $shippingDetails
        ], 200);
    }

    // Store new shipping details
    public function store(Request $request)
    {
        $validatedData = $request->validate([
            'name' => 'required|string',
            'country' => 'required|string',
            'address' => 'required|string',
            'street' => 'required|string',
            'floor' => 'required|string',
            'note_to_rider' => 'nullable|string'
        ]);

        $shippingDetail = ShippingDetail::create($validatedData);

        return response()->json([
            'success' => true,
            'message' => 'Shipping details saved successfully.',
            'data' => $shippingDetail
        ], 201);
    }

    // Show a single shipping detail by ID
    public function show($id)
    {
        $shippingDetail = ShippingDetail::find($id);

        if (!$shippingDetail) {
            return response()->json([
                'success' => false,
                'message' => 'Shipping detail not found.'
            ], 404);
        }

        return response()->json([
            'success' => true,
            'data' => $shippingDetail
        ], 200);
    }
}
