<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ProfileSetting;
use Illuminate\Support\Facades\Auth;

class ProfileSettingController extends Controller
{
    public function getVisibility()
    {
        $user = Auth::user();

        if ($user->role !== 'beautician') {
            return response()->json(['message' => 'Access denied. Only beauticians can manage profile visibility.'], 403);
        }

        $profileSetting = ProfileSetting::where('beautician_id', $user->id)->first();

        return response()->json([
            'status' => true,
            'visibility' => $profileSetting ? $profileSetting->visibility : 'public',
        ]);
    }

    public function updateVisibility(Request $request)
    {
        $request->validate([
            'visibility' => 'required|in:public,private,clients_only',
        ]);

        $user = Auth::user();

        if ($user->role !== 'beautician') {
            return response()->json(['message' => 'Access denied. Only beauticians can manage profile visibility.'], 403);
        }

        $profileSetting = ProfileSetting::updateOrCreate(
            ['beautician_id' => $user->id],
            ['visibility' => $request->visibility]
        );

        return response()->json([
            'status' => true,
            'message' => 'Profile visibility updated successfully.',
            'visibility' => $profileSetting->visibility,
        ]);
    }
}
