<?php

namespace App\Http\Controllers;

use App\Models\Product;
use Illuminate\Http\Request;

class ProductController extends Controller
{
    // public function show($id)
    // {
    //     // Get Product Details
    //     $product = Product::with(['images', 'sizes'])->find($id);

    //     if (!$product) {
    //         return response()->json(['message' => 'Product not found'], 404);
    //     }

    //     // Get Popular Products (e.g., top-rated or most sold)
    //     $popularProducts = Product::orderBy('rating', 'desc')->take(5)->get();

    //     // Get Similar Products (e.g., same category)
    //     $similarProducts = Product::where('category_id', $product->category_id)
    //         ->where('id', '!=', $id)
    //         ->take(5)
    //         ->get();

    //     return response()->json([
    //         'product' => [
    //             'name' => $product->name,
    //             'rating' => $product->rating,
    //             'reviews' => $product->reviews,
    //             'size' => $product->sizes,
    //             'price' => $product->price,
    //             'images' => $product->images,
    //             'guarantee' => '100% Genuine Product Guarantee',
    //             'description' => $product->description,
    //             'wishlist' => false // Default not added
    //         ],
    //         'popular_this_week' => $popularProducts,
    //         'similar_products' => $similarProducts,
    //     ]);
    // }

    // Show Product Detail
      // ✅ 1. Get Product Details
      public function show($id)
      {
          $product = Product::with(['reviews'])->find($id);

          if (!$product) {
              return response()->json(['message' => 'Product not found'], 404);
          }

          return response()->json([
              'product' => [
                  'name' => $product->name,
                  'rating' => $product->rating,
                  'reviews' => $product->reviews,
                  'price' => $product->price,
                  'description' => $product->description,
                  'size_options' => json_decode($product->size_options),
                  'images' => json_decode($product->images),
                  'guarantee' => '100% Original & Money Back Guarantee',
              ],
          ]);
      }

      // ✅ 2. Get Popular This Week Products
      public function popularProducts()
      {
          $popularProducts = Product::orderBy('rating', 'desc')->take(10)->get();

          return response()->json(['popular_products' => $popularProducts]);
      }

      // ✅ 3. Get Similar Products
      public function similarProducts($id)
      {
          $product = Product::find($id);

          if (!$product) {
              return response()->json(['message' => 'Product not found'], 404);
          }

          $similarProducts = Product::where('category_id', $product->category_id)
              ->where('id', '!=', $id)
              ->take(10)
              ->get();

          return response()->json(['similar_products' => $similarProducts]);
      }

      // ✅ 4. Search Products
      public function search(Request $request)
      {
          $query = $request->input('query');

          if (!$query) {
              return response()->json(['message' => 'Query parameter is required'], 400);
          }

          $products = Product::where('name', 'LIKE', "%$query%")->get();

          return response()->json(['results' => $products]);
      }

      // ✅ 5. Add to Wishlist
      public function addToWishlist(Request $request)
      {
          // Simulating a wishlist save
          return response()->json(['message' => 'Product added to wishlist successfully']);
      }

}
