<?php

namespace App\Http\Controllers;

use App\Models\PortfolioSetting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class PortfolioSettingController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:sanctum');
    }

    // Get Portfolio Visibility
    public function show()
    {
        $beauticianId = Auth::id();
        $setting = PortfolioSetting::where('beautician_id', $beauticianId)->first();

        if (!$setting) {
            return response()->json(['message' => 'Portfolio visibility not set'], 404);
        }

        return response()->json(['visibility' => $setting->visibility], 200);
    }

    // Update Portfolio Visibility
    public function update(Request $request)
    {
        $request->validate([
            'visibility' => 'required|in:public,private,clients_only',
        ]);

        $beauticianId = Auth::id();
        $setting = PortfolioSetting::updateOrCreate(
            ['beautician_id' => $beauticianId],
            ['visibility' => $request->visibility]
        );

        return response()->json(['message' => 'Portfolio visibility updated successfully', 'visibility' => $setting->visibility], 200);
    }
}
