<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\Service;
use App\Models\Brand;
use App\Models\Salon;
use Illuminate\Http\JsonResponse;


class HomeController extends Controller
{
    public function index(): JsonResponse
    {
        $products = Product::all();
        // $products = Product::latest()->take(10)->get(); // Get latest 10 products
        // $services = Service::all();
        //         $services = Service::latest()->take(10)->get(); // Get latest 10 services
        $topBrands = Brand::all(); // Fetch all brands (You can add conditions like 'top' brands)
        // $topBrands = Brand::where('is_top', true)->get();
        // $topBrands = Brand::orderBy('popularity', 'desc')->limit(5)->get();
        // $topBrands = Brand::where('is_top', true)->orderBy('popularity', 'desc')->take(5)->get(); // Get top brands




        return response()->json([
            'featured_products' => $products,
            // 'services' => $services,
            'top_brands' => $topBrands,
        ], 200);
    }

    public function salonDetails(): JsonResponse
    {
        // Fetch demo videos of popular salons (assuming you have a 'demo_video' column)
        $popularSalons = Salon::where('is_popular', true)->get(['id', 'name', 'demo_video']);

        // Fetch list of salons with details
        $salons = Salon::all()->map(function ($salon) {
            return [
                'id' => $salon->id,
                'name' => $salon->name,
                'rating' => $salon->rating,
                'reviews' => $salon->reviews,
                'price' => $salon->price,
                'discount' => $salon->discount, // Percentage off
                'book_now' => url("/api/book-salon/{$salon->id}"),
            ];
        });

        // Fetch list of services offered by salons
        $services = Service::all()->map(function ($service) {
            return [
                'id' => $service->id,
                'name' => $service->name,
                'rating' => $service->rating,
                'reviews' => $service->reviews,
                'price' => $service->price,
                'discount' => $service->discount, // Percentage off
                'like' => true, // Assume all services are liked for now
                'book_now' => url("/api/book-service/{$service->id}"),
            ];
        });

        return response()->json([
            'demo_videos' => $popularSalons, // Popular salon demo videos
            'salons' => $salons, // List of salons
            'services' => $services, // List of salon services
        ], 200);
    }
}
