<?php
// app/Http/Controllers/BeauticianController.php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;

class ContactNumberController extends Controller
{
    // Show Beautician Profile (includes phone)
    public function showProfile(Request $request)
    {
        $user = $request->user(); // Get the authenticated user
        return response()->json([
            'status' => true,
            'message' => 'Beautician profile retrieved successfully',
            'profile' => [
                'name' => $user->name,
                'email' => $user->email,
                'phone' => $user->phone, // Return phone number
            ]
        ]);
    }

    // Update Beautician Phone Number
    public function updatePhone(Request $request)
    {
        $user = $request->user(); // Get the authenticated user

        // Validate phone number input
        $request->validate([
            'phone' => 'required|string|max:15',
        ]);

        // Update the user's phone number
        $user->phone = $request->phone;
        $user->save();

        return response()->json([
            'status' => true,
            'message' => 'Phone number updated successfully',
            'phone' => $user->phone
        ]);
    }

    // Delete Beautician Phone Number
    public function deletePhone(Request $request)
    {
        $user = $request->user(); // Get the authenticated user

        // Set phone to null and save
        $user->phone = null;
        $user->save();

        return response()->json([
            'status' => true,
            'message' => 'Phone number deleted successfully'
        ]);
    }
}
