<?php

namespace App\Http\Controllers;

use App\Http\Resources\BeauticianServiceResource;
use App\Models\BeauticianService;
use App\Models\Service;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class BeauticianServiceController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:sanctum');
    }

    // Get all available services
    public function availableServices()
    {
        return response()->json(Service::all(), 200);
    }

    // Get services offered by the beautician
    // public function index()
    // {
    //     $services = Auth::user()->beauticianServices()->with('service')->get();
    //     return BeauticianServiceResource::collection($services);
    // }

    // Beautician selects a service to offer
    public function store(Request $request)
    {
        $validated = $request->validate([
            'service_id' => 'required|exists:services,id',
        ]);

        $service = BeauticianService::updateOrCreate(
            ['beautician_id' => Auth::id(), 'service_id' => $validated['service_id']],
            ['status' => 'active']
        );

        return new BeauticianServiceResource($service);
    }

    // Remove a service from offered list
    public function destroy($id)
    {
        $service = BeauticianService::where('beautician_id', Auth::id())->where('id', $id)->first();

        if (!$service) {
            return response()->json(['message' => 'Service not found'], 404);
        }

        $service->delete();
        return response()->json(['message' => 'Service removed successfully'], 200);
    }
}
