<?php

namespace App\Http\Controllers;

use App\Models\Review;
use App\Models\User;
use Illuminate\Http\Request;

class BeauticianReviewController extends Controller
{
    public function showProfile($beauticianId)
    {
        // Get the beautician (make sure it exists)
        $beautician = User::find($beauticianId);

        if (!$beautician) {
            return response()->json([
                'message' => 'Beautician not found'
            ], 404);
        }

        // Get reviews for the beautician and calculate total reviews and average rating
        $reviewsQuery = Review::where('beautician_id', $beauticianId);
        $totalReviews = $reviewsQuery->count();
        $averageRating = $totalReviews > 0 ? $reviewsQuery->avg('rating') : 0;

        // Eager load the reviewers for the reviews
        $reviews = $reviewsQuery->with('reviewer')->get();

        // Get the users who gave the reviews
        $usersWhoReviewed = $reviews->map(function ($review) {
            return [
                'user_id' => $review->user_id,
                'name' => $review->reviewer->name,
                'rating' => $review->rating,
                'comment' => $review->comment,
            ];
        });

        return response()->json([
            'beautician' => [
                'id' => $beautician->id,
                'name' => $beautician->name,
                'total_reviews' => $totalReviews,
                'average_rating' => $averageRating,
                'reviews' => $usersWhoReviewed,
            ]
        ], 200);
    }


}
