<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\BeauticianOrder;
use Carbon\Carbon;
// use DB;
use Illuminate\Support\Facades\DB;

class BeauticianOrderStatsController extends Controller
{
    public function stats($beauticianId)
    {
        // Total Orders
        $totalOrders = BeauticianOrder::where('user_id', $beauticianId)->count();

        // Grouped by month: accepted
        $accepted = BeauticianOrder::select(
                DB::raw("DATE_FORMAT(created_at, '%Y-%m') as month"),
                DB::raw("COUNT(*) as total")
            )
            ->where('user_id', $beauticianId)
            ->where('status', 'accepted')
            ->groupBy('month')
            ->orderBy('month')
            ->get();

        // Grouped by month: rejected
        $rejected = BeauticianOrder::select(
                DB::raw("DATE_FORMAT(created_at, '%Y-%m') as month"),
                DB::raw("COUNT(*) as total")
            )
            ->where('user_id', $beauticianId)
            ->where('status', 'rejected')
            ->groupBy('month')
            ->orderBy('month')
            ->get();

        return response()->json([
            'total_orders' => $totalOrders,
            'chart_data' => [
                'accepted' => $accepted,
                'rejected' => $rejected
            ]
        ]);
    }
}
