<?php

namespace App\Http\Controllers;

use App\Models\BeauticianOrder;
use Illuminate\Http\Request;
use Carbon\Carbon;

class BeauticianOrderController extends Controller
{
    public function store(Request $request)
{
    // Validate incoming request
    $validated = $request->validate([
        'user_id' => 'required|exists:users,id',
        'item_name' => 'required|string',
        'quantity' => 'required|integer',
        'type' => 'required|string',
        'price' => 'required|numeric',
    ]);

    // Create a new order
    $order = BeauticianOrder::create($validated);

    // Return the created order in response
    return response()->json([
        'message' => 'Order created successfully',
        'order' => $order
    ], 201);
}

    // Show list of orders for the beautician
    public function index(Request $request)
    {
        $orders = BeauticianOrder::where('user_id', $request->user()->id)  // Only show orders related to the authenticated beautician
            ->orderByDesc('created_at')
            ->get()
            ->map(function ($order) {
                $order->order_time = Carbon::parse($order->created_at)->diffForHumans();  // "X minutes ago"
                return $order;
            });

        return response()->json([
            'orders' => $orders
        ]);
    }

    // Accept an order
    public function accept($orderId)
    {
        $order = BeauticianOrder::find($orderId);

        if (!$order) {
            return response()->json([
                'message' => 'Order not found'
            ], 404);
        }

        $order->status = 'accepted';
        $order->save();

        return response()->json([
            'message' => 'Order accepted successfully',
            'order' => $order
        ]);
    }

    // Reject an order
    public function reject($orderId)
    {
        $order = BeauticianOrder::find($orderId);

        if (!$order) {
            return response()->json([
                'message' => 'Order not found'
            ], 404);
        }

        $order->status = 'rejected';
        $order->save();

        return response()->json([
            'message' => 'Order rejected successfully',
            'order' => $order
        ]);
    }
}
