<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;
use App\Models\Order;

class BeauticianCustomerDetailController extends Controller
{
    public function showCustomerDetails($orderId)
    {
        $order = Order::findOrFail($orderId);

        $customer = User::find($order->user_id);

        // Dummy services (until service table is migrated)
        $services = [
            [
                'name' => 'Facial',
                'image' => 'facial.jpg',
                'price' => 1000
            ],
            [
                'name' => 'Haircut',
                'image' => 'haircut.jpg',
                'price' => 500
            ]
        ];

        $totalPrice = array_sum(array_column($services, 'price'));

        // Previous Orders
        $previousOrders = Order::where('user_id', $order->user_id)
                                ->where('id', '!=', $order->id)
                                ->select('id as order_id', 'item_name', 'price', 'status')
                                ->get();

        return response()->json([
            'order_id' => $order->id,
            'appointment_date' => $order->created_at->toDateString(),
            'appointment_time' => $order->created_at->format('g:i A'),
            'customer' => [
                'id' => $customer->id,
                'name' => $customer->name,
                'phone' => $customer->phone
            ],
            'services' => $services,
            'total_price' => $totalPrice,
            'previous_orders' => $previousOrders
        ]);
    }
}
