<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;


class BeauticianController extends Controller
{
//     public function registerBeautician(Request $request)
// {
//     $request->validate([
//         'name' => 'required|string|max:255',
//         'email' => 'required|string|email|max:255|unique:users',
//         'password' => 'required|string|min:6'
//     ]);

//     $beautician = new User();
//     $beautician->name = $request->name;
//     $beautician->email = $request->email;
//     $beautician->password = Hash::make($request->password);
//     $beautician->role = 'beautician'; // Ensure the role is set
//     $beautician->save();

//     return response()->json([
//         'status' => true,
//         'message' => 'Beautician registered successfully',
//         'user' => $beautician
//     ], 201);
// }


// public function loginBeautician(Request $request)
// {
//     $request->validate([
//         'email' => 'required|string|email',
//         'password' => 'required|string'
//     ]);

//     $user = User::where('email', $request->email)->first();

//     if (!$user || !Hash::check($request->password, $user->password)) {
//         return response()->json(['message' => 'Invalid beautician credentials'], 401);
//     }

//     if ($user->role !== 'beautician') {
//         return response()->json(['message' => 'Unauthorized: Not a beautician'], 403);
//     }

//     $token = $user->createToken('beautician-token')->plainTextToken;

//     return response()->json([
//         'status' => true,
//         'message' => 'Beautician logged in successfully',
//         'token' => $token,
//         'user' => $user
//     ]);
// }




    public function profile(): JsonResponse
    {
        $user = Auth::user();

        if ($user->role !== 'beautician') {
            return response()->json([
                'status' => false,
                'message' => 'Access denied. Only beauticians can view this profile.'
            ], 403);
        }

        return response()->json([
            'status' => true,
            'message' => 'Beautician profile retrieved successfully',
            'user' => $user
        ]);
    }
}
