<?php

namespace App\Http\Controllers;

use App\Models\BeauticianAvailability;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class BeauticianAvailabilityController extends Controller
{
    public function __construct()
    {
        $this->middleware('auth:sanctum');
    }

    // View Availability
    public function index()
    {
        return response()->json(Auth::user()->availabilities, 200);
    }

    // Add or Update Availability
    public function store(Request $request)
    {
        $validated = $request->validate([
            'available_date' => 'required|date',
            'start_time' => 'required|date_format:H:i',
            'end_time' => 'required|date_format:H:i|after:start_time',
        ]);

        $availability = BeauticianAvailability::updateOrCreate(
            ['beautician_id' => Auth::id(), 'available_date' => $validated['available_date']],
            $validated
        );

        return response()->json(['message' => 'Availability updated successfully', 'availability' => $availability], 201);
    }

    // Delete Availability
    public function destroy($id)
    {
        BeauticianAvailability::where('beautician_id', Auth::id())->where('id', $id)->delete();
        return response()->json(['message' => 'Availability deleted successfully'], 200);
    }
}
