<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Appointment;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;

class AppointmentController extends Controller
{
    // Get list of upcoming appointments
    public function index()
    {



        // $appointments = Appointment::where('status', 'upcoming')
        $appointments = Appointment::whereDate('appointment_date', '>=', Carbon::today())
            ->orderBy('appointment_date', 'asc')
            // ->get(['id', 'appointment_date', 'salon_name', 'rating', 'review', 'services', 'total']);
            ->get();

        return response()->json([
            'status' => true,
            'message' => 'Upcoming Appointments',
            'data' => $appointments->map(function ($appointment) {
                return [
                        'id' => $appointment->id,
                        'date' => $appointment->appointment_date,
                        'name' => $appointment->salon->name ?? 'Unknown Salon', // Ensure relationship exists
                        'rating' => $appointment->rating ?? 0, // Check if column exists
                        'review' => $appointment->review ?? '',
                        'services' => json_decode($appointment->services, true) ?? [],
                        'total' => $appointment->total ?? 0,
                        'reschedule_button' => route('appointments.reschedule', $appointment->id),
                        'cancel_button' => route('appointments.cancel', $appointment->id),
        ];
        // return response()->json([
        //     'status' => true,
        //     'message' => 'Upcoming Appointments',
        //     'data' => $appointments->map(function ($appointment) {
        //         return [
        //             'id' => $appointment->id,
        //             'date' => $appointment->appointment_date,
        //             'name' => $appointment->salon_name,
        //             'rating' => $appointment->rating,
        //             'review' => $appointment->review,
        //             'services' => json_decode($appointment->services),
        //             'total' => $appointment->total,
        //             'reschedule_button' => route('appointments.reschedule', $appointment->id),
        //             'cancel_button' => route('appointments.cancel', $appointment->id)
        //         ];
            })
        ]);
    }



    public function listAppointments()
    {
        $appointments = Appointment::where('status', 'upcoming')
            ->orderBy('appointment_date', 'asc')
            ->get(['id', 'appointment_date', 'username', 'rating', 'review', 'services', 'total']);

        return response()->json(['appointments' => $appointments]);
    }
    // Store Appointment
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'username' => 'required|string|max:255',
            'email' => 'required|email',
            'phone_number' => 'required|string|max:15',
            'appointment_type' => 'required|string',
            'appointment_time' => 'required|date_format:Y-m-d H:i:s',
        ]);

        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()], 400);
        }

        $appointment = Appointment::create($request->all());

        return response()->json([
            'message' => 'Appointment booked successfully!',
            'appointment' => $appointment
        ], 201);
    }

    // Confirm Appointment
    public function confirm($id)
    {
        $appointment = Appointment::find($id);
        if (!$appointment) {
            return response()->json(['message' => 'Appointment not found'], 404);
        }

        $appointment->update(['status' => 'confirmed']);

        return response()->json(['message' => 'Appointment confirmed successfully!']);
    }

    // Cancel Appointment
    public function cancel($id)
    {
        $appointment = Appointment::find($id);
        if (!$appointment) {
            return response()->json(['message' => 'Appointment not found'], 404);
        }

        $appointment->update(['status' => 'canceled']);

        return response()->json(['message' => 'Appointment canceled successfully!']);
    }

    public function book(Request $request)
    {
        $validatedData = $request->validate([
            'username' => 'required|string|max:255',
            'email' => 'required|email',
            'phone_number' => 'required|string',
            'appointment_type' => 'required|string',
            'appointment_time' => 'required|date_format:Y-m-d H:i:s',
        ]);

        $appointment = Appointment::create($validatedData);

        return response()->json([
            'message' => 'Appointment booked successfully!',
            'appointment' => $appointment
        ]);
    }


//     public function show($id)
// {
//     $appointment = Appointment::find($id);

//     if (!$appointment) {
//         return response()->json(['message' => 'Appointment not found'], 404);
//     }

//     return response()->json($appointment);
// }
public function show($id)
    {
        $appointment = Appointment::find($id);

        $appointment = Appointment::where('id', $id)
            ->where('user_id', Auth::id())
            ->first();

        if (!$appointment) {
            return response()->json(['status' => 'error', 'message' => 'Appointment not found'], 404);
        }

        return response()->json([
            'status' => 'success',
            'appointment' => $appointment,

            'message' => 'Appointment Details',
            'data' => [
                'id' => $appointment->id,
                'date' => $appointment->appointment_date,
                'name' => $appointment->salon->name ?? 'Unknown Salon',
                'rating' => $appointment->rating ?? 0,
                'review' => $appointment->review ?? '',
                'services' => json_decode($appointment->services, true) ?? [],
                'total' => $appointment->total ?? 0,
            ]
        ]);
    }
}
