<?php

namespace App\Http\Controllers\Admin;

use App\Models\Order;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;


class OrderController extends Controller
{
    // Fetch Product Sales (Orders with status 'to_pay')
    public function getProductSales(Request $request)
    {
        // Fetch total sales for orders with status 'to_pay'
        $totalSales = Order::where('status', 'to_pay')
            ->sum(DB::raw('price * quantity')); // Assuming price is the unit price and quantity is the quantity of the product ordered

        return response()->json([
            'status' => true,
            'message' => 'Product Sales Overview',
            'data' => [
                'total_sales' => $totalSales
            ]
        ]);
    }
}
