<?php

namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Appointment;
use App\Models\Staff;
use Illuminate\Support\Facades\Auth;

class SalonBookingController extends Controller
{
    // Get available staff for the selected date
    public function getAvailableStaff(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'salon_id' => 'required|exists:salons,id',
            'date' => 'required|date',
        ]);

        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()], 422);
        }

        $bookedStaffIds = Appointment::where('date', $request->date)->pluck('staff_id')->toArray();


        $staff = Staff::where('salon_id', $request->salon_id)
                        ->whereNotIn('id', $bookedStaffIds)
                        ->get(['id', 'name', 'thumbnail', 'rating', 'reviews', 'price']);

        return response()->json(['staff' => $staff], 200);
    }

    // Book an appointment
    public function bookAppointment(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'user_id' => 'required|exists:users,id',
            'salon_id' => 'required|exists:salons,id',
            'staff_id' => 'required|exists:staff,id',
            'date' => 'required|date',
            'time' => 'required',
            'appointment_type' => 'required|string',
            'username' => 'required|string',
            'email' => 'required|email',
            'phone' => 'required|string',
        ]);

        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors(), 'request' => $request->all()], 422);
        }


        $appointment = Appointment::create([
            'user_id' => $request->user_id,
            'salon_id' => $request->salon_id,
            'staff_id' => $request->staff_id,
            'date' => $request->date,
            'time' => $request->time,
            'appointment_type' => $request->appointment_type,
            'username' => $request->username,
            'email' => $request->email,
            'phone' => $request->phone,
            'status' => 'pending',
        ]);

        return response()->json(['message' => 'Appointment booked successfully!', 'appointment' => $appointment], 201);
    }
}
