<?php


namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\User;


class AdminController extends Controller
{
    public function getUsers()
    {
        $users = User::select('id', 'name', 'email', 'role', 'status', 'created_at')->get();

        return response()->json([
            'success' => true,
            'message' => 'Users retrieved successfully',
            'users' => $users
        ]);
    }

    public function updateUserStatus(Request $request, $id)
    {
        $request->validate([
            'status' => 'required|in:active,inactive'
        ]);

        $user = User::find($id);
        if (!$user) {
            return response()->json([
                'success' => false,
                'message' => 'User not found'
            ], 404);
        }

        $user->status = $request->status;
        $user->save();

        return response()->json([
            'success' => true,
            'message' => 'User status updated successfully',
            'user' => $user
        ]);
    }

    public function getBookings()
    {
        $bookings = Booking::with(['customer:id,name', 'salon:id,name'])
            ->select('id', 'customer_id', 'salon_id', 'service_id', 'date', 'time', 'status')
            ->get();

        return response()->json([
            'success' => true,
            'message' => 'Bookings retrieved successfully',
            'bookings' => $bookings
        ]);
    }

    public function getSalesOverview()
    {
        $totalRevenue = ProductSale::sum('amount');
        $totalBookings = Booking::count();

        return response()->json([
            'success' => true,
            'message' => 'Sales overview retrieved successfully',
            'data' => [
                'total_bookings' => $totalBookings,
                'total_revenue' => $totalRevenue
            ]
        ]);
    }
}
