<?php

namespace App\Http\Controllers;

use App\Models\Tutor;
use App\Models\User;
use App\Mail\WelcomeMail;
use App\Rules\AccountDeleted;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\Request;
use Illuminate\Validation\Rule;
use App\Http\Resources\UserResource;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Mail;
use App\Http\Resources\LoginResource;
use Illuminate\Validation\Rules\File;
use Illuminate\Validation\Rules\Password;
use App\Notifications\PasswordResetRequest;
use App\Http\Resources\NotificationResource;
use Illuminate\Validation\ValidationException;
use App\Http\Resources\TutorResource;
use App\Mail\RegisterUserMail;
use App\Mail\ResetPasswordMail;
use App\Notifications\FirebaseNotificationService;

use Illuminate\Support\Facades\Validator;


class AuthController extends Controller
{



    public function register(Request $request)
    {
    //     // Validate input
    //     $validator = Validator::make($request->all(), [
    //         'name' => 'required|string|max:255',
    //         'email' => 'required|string|email|max:255|unique:users',
    //         'password' => 'required|string|min:8',
    //     ]);

    //     if ($validator->fails()) {
    //         return response()->json(['errors' => $validator->errors()], 422);
    //     }

    //     // Create user
    //     $user = User::create([
    //         'name' => $request->name,
    //         'email' => $request->email,
    //         'password' => Hash::make($request->password),
    //     ]);

    //     return response()->json([
    //         'message' => 'User registered successfully',
    //         'user' => $user,
    //     ], 201);
    // }


    // public function register(Request $request)
    // {
    //     // Validation remains the same
    //     $validData = $request->validate([
    //         'name' => ['required', 'string', 'max:191'],
    //         'email' => ['required', 'string', 'email', 'max:191', new AccountDeleted(), 'unique:' . User::class],
    //         'password' => ['required', 'confirmed', Password::defaults()],
    //         'profile_picture' => [
    //             'nullable',
    //             File::image()->min('1kb')->max('25mb')
    //         ],
    //         'phone' => ['nullable', 'string', 'max:30'],
    //         'gender' => ['required', 'string', 'in:male,female,non-binary'],
    //         'device_id' => ['required', 'string', 'max:191'], // Ensure device_id is passed
    //         'is_tutor' => ['nullable', 'boolean'],
    //         'location' => ['nullable', 'string', 'max:191'],
    //         'city' => ['nullable', 'string', 'max:100'],
    //         'state' => ['nullable', 'string', 'max:100'],
    //         'state_code' => ['nullable', 'string', 'max:10'],
    //         'country' => ['nullable', 'string', 'max:100'],
    //         'country_code' => ['nullable', 'string', 'max:5'],
    //         'latlng' => ['nullable', 'string', 'max:190'],
    //         'tutor_documents' => ['nullable', File::image()->min('1kb')->max('25mb')],
    //         'tutor_verified' => ['nullable', 'boolean'],
    //     ]);

    //     $validData['password'] = Hash::make($request->password);
    //     if ($request->hasFile('profile_picture')) {
    //         $validData['profile_picture'] = $request->profile_picture->store('users');
    //     } else {
    //         unset($validData['profile_picture']);
    //     }

    //     if ($request->hasFile('tutor_documents')) {
    //         $validData['tutor_documents'] = $request->tutor_documents->store('tutor_documents');
    //         $validData['tutor_verified'] = false;
    //     }

    //     // Creating the user
    //     $user = User::create($validData); // User account created

    //     if ($request->hasFile('profile_video')) {
    //         $validData['profile_video'] = $request->profile_picture->store('tutors');
    //     }

    //     // If user is registering as a tutor
    //     if ($user->is_tutor) {
    //         Tutor::create([
    //             'user_id' => $user->id,
    //             'phone' => $request->input('phone', ''),
    //             'name' => $request->input('name', ''),
    //             'about' => $request->input('about', ''),
    //             'email' => $user->email,
    //             'package' => $request->input('package', ''),
    //             'profile_video' => $request->input('profile_video', ''),
    //             'location' => $request->input('location', ''),
    //             'city' => $request->input('city', ''),
    //             'state' => $request->input('state', ''),
    //             'country' => $request->input('country', ''),
    //             'tutor_verified' => $request->input('tutor_verified', 0),
    //         ]);

    //     }

    //     $token = $user->createToken('user-token');
    //     $user->token = $token->plainTextToken;

    //     // Send registration email (unchanged)
    //     Mail::to($user->email)->send(new RegisterUserMail($user, $user->is_tutor));

    //     // NEW: Trigger Firebase Notification after user creation
    //     $notificationService = new FirebaseNotificationService(); // Create notification service

    //     // Use the device_id from the user model (assumed saved during registration)
    //     $deviceToken = $user->device_id; // Fetch stored device token from user

    //     // Conditional notification based on whether the user is a tutor or not
    //     if ($user->is_tutor) {
    //         // Send notification for tutor registration
    //         $notificationService->sendNotification(
    //             $deviceToken,
    //             'Welcome Tutor!', // Title of the notification
    //             'Your tutor account has been successfully created. You can now start teaching!' // Body
    //         );
    //     } else {
    //         // Send notification for regular user registration
    //         $notificationService->sendNotification(
    //             $deviceToken,
    //             'Welcome!',
    //             'Your account has been successfully created. Start your learning journey now!'
    //         );
    //     }

    //     // Return user response with the token
    //     return new LoginResource($user);
    // }


    /**
     * > If the user's credentials are valid, create a token and return it
     *
     * @param Request request The request object.
     *
     * @return LoginResource
     */
    // public function login(Request $request)
    // {
    //     $validData = $request->validate([
    //         'email' => ['required', 'string', 'email', 'max:255', new AccountDeleted()],
    //         'password' => ['required', Password::defaults()],
    //         'device_id' => ['nullable', 'string', 'max:191'],
    //     ]);

    //     if (!Auth::attempt($validData)) {
    //         throw ValidationException::withMessages([
    //             'email' => trans('auth.failed'),
    //         ]);
    //     }

    //     $user = User::findOrFail(Auth::id());
    //     if ($request->filled('device_id')) {
    //         $user->device_id = $validData['device_id'];
    //         $user->save();
    //     }

    //     $token = $user->createToken('user-token');
    //     $user->token = $token->plainTextToken;
    //     return new LoginResource($user);
    }

    public function login(Request $request)
    {
    // Validate request
    $validData = $request->validate([
        'email' => ['required', 'string', 'email', 'max:255', new AccountDeleted()],
        'password' => ['required', Password::defaults()],
        'device_id' => ['nullable', 'string', 'max:191'],
    ]);

    // Attempt login
    if (!Auth::attempt($validData)) {
        throw ValidationException::withMessages([
            'email' => trans('auth.failed'),
        ]);
    }

    // Get authenticated user
    $user = User::findOrFail(Auth::id());

    // Save device_id if provided
    if ($request->filled('device_id')) {
        $user->device_id = $validData['device_id'];
        $user->save();
    }

    // Create token for user
    $token = $user->createToken('user-token');
    $user->token = $token->plainTextToken;

    // Check if the user is a tutor and retrieve tutor_id if applicable
    $tutor = null;
    if ($user->is_tutor == 1) {
        $tutor = \App\Models\Tutor::where('user_id', $user->id)->first();
    }

    // Pass user and tutor data to the resource
    return new LoginResource($user, $tutor);
}


    /**
     * It creates a new user, fires the `Registered` event, creates a token for the user, and returns
     * the token
     *
     * @param Request request The request object.
     *
     * @return LoginResource
     */
    // public function register(Request $request)
    // {
    //     $validData = $request->validate([
    //         'name' => ['required', 'string', 'max:191'],
    //         'email' => ['required', 'string', 'email', 'max:191', new AccountDeleted(), 'unique:' . User::class],
    //         'password' => ['required', 'confirmed', Password::defaults()],
    //         'profile_picture' => [
    //             'nullable',
    //             File::image()
    //                 ->min('1kb')
    //                 ->max('25mb')
    //         ],
    //         'phone' => ['nullable', 'string', 'max:30'],
    //         'gender' => ['required', 'string', 'in:male,female,non-binary'],
    //         'device_id' => ['required', 'string', 'max:191'],
    //         'is_tutor' => ['nullable', 'boolean'],
    //         'location' => ['nullable', 'string', 'max:191'],
    //         'city' => ['nullable', 'string', 'max:100'],
    //         'state' => ['nullable', 'string', 'max:100'],
    //         'state_code' => ['nullable', 'string', 'max:10'],
    //         'country' => ['nullable', 'string', 'max:100'],
    //         'country_code' => ['nullable', 'string', 'max:5'],
    //         'latlng' => ['nullable', 'string', 'max:190'],
    //         'tutor_documents' => ['nullable', File::image()->min('1kb')->max('25mb')], // Add document upload field
    //         'tutor_verified' => ['nullable', 'boolean'],
    //         // 'days' => ['nullable', 'string'], // Change this according to your schema
    //         // Add tutor verification status field

    //     ]);

    //     $validData['password'] = Hash::make($request->password);
    //     if ($request->hasFile('profile_picture')) {
    //         $validData['profile_picture'] = $request->profile_picture->store('users');
    //     }
    //      else {
    //         unset($validData['profile_picture']);
    //     }

    //     if ($request->hasFile('tutor_documents')) {
    //         $validData['tutor_documents'] = $request->tutor_documents->store('tutor_documents');
    //         $validData['tutor_verified'] = false; // Set tutor_verified to false initially
    //     }

    //     $user = User::create($validData);

    //     // if ($user->is_tutor) {
    //     //     Tutor::create([
    //     //         'user_id' => $user->id,
    //     //         'phone' => $user->phone,
    //     //         'about' => $request->input('about', ''),
    //     //         // Initialize other tutor fields if needed
    //     //         'name' => $request->input('name'), // or any other default value
    //     //         'email' => $user->email, // or any other default value
    //     //     ]);
    //     // }
    //     $validData['profile_video'] = null;
    //     if ($request->hasFile('profile_video')) {
    //         $validData['profile_video'] = $request->profile_picture->store('tutors');
    //     }
    //     if ($user->is_tutor) {
    //         Tutor::create([
    //             'user_id' => $user->id, // Foreign key to the user
    //             'phone' => $request->input('phone', ''), // Provide default value if not present
    //             'name' => $request->input('name', ''), // Provide default value if not present
    //             'about' => $request->input('about', ''), // Provide default value if not present
    //             'email' => $user->email, // Use the user's email
    //             'package' => $request->input('package', ''), // Provide default value if not present
    //             'profile_video' => $request->input('profile_video', ''), // Example of additional fields
    //             // 'days' => $validData['days'],
    //             'location' => $request->input('location', ''), // Example of additional fields
    //             'city' => $request->input('city', ''), // Example of additional fields
    //             'state' => $request->input('state', ''), // Example of additional fields
    //             'country' => $request->input('country', ''), // Example of additional fields
    //             'tutor_verified' => $request->input('tutor_verified', 0), // Example of additional fields
    //         ]);

    //     }

    //     // $user = User::create($request->all());
    //     // event(new Registered($user));

    //     $token = $user->createToken('user-token');
    //     $user->token = $token->plainTextToken;
    //     // Mail::to($user->email)->send(new RegisterUserMail($user));
    //     Mail::to($user->email)->send(new RegisterUserMail($user, $user->is_tutor));


    //     // Mail::to($user)->send(new WelcomeMail($user));

    //     return new LoginResource($user);
    // }

//testing notification on creation case handled



    public function storeTutorDetails(Request $request)
    {
        $request->validate([
            'phone' => ['required', 'string', 'max:15'],
            'name' => ['required', 'string', 'max:255'],
            'about' => ['nullable', 'string'],
            'package' => ['nullable', 'string'],
            'email' => ['required', 'string', 'email', 'max:255'],
            'profile_video' => ['nullable', 'string'],
            'days' => ['nullable', 'string'],
            'location' => ['nullable', 'string'],
            'city' => ['nullable', 'string'],
            'state' => ['nullable', 'string'],
            'country' => ['nullable', 'string'],
        ]);

        $user = Auth::user();

        $tutor = Tutor::updateOrCreate(
            ['user_id' => $user->id],
            [
                'phone' => $request->phone,
                'name' => $request->name,
                'about' => $request->about,
                'package' => $request->package,
                'email' => $request->email,
                'profile_video' => $request->profile_video,
                'days' => $request->days,
                'location' => $request->location,
                'city' => $request->city,
                'state' => $request->state,
                'country' => $request->country,
            ]
        );

        return response()->json(['message' => 'Tutor details saved successfully', 'tutor' => $tutor]);
    }


    /**
     * It deletes all the Auth tokens associated with the user
     *
     * @return JSON response with a message.
     */
    public function logout()
    {
        Auth::user()->currentAccessToken()->delete();

        return response()->json(['message' => __('Logged out Successfully')]);
    }


    public function destroy()
    {
        Auth::user()->delete();

        return response()->json(['message' => __('Profile deleted Successfully')]);
    }

    public function profile()
    {
        $user = Auth::user();
        return new UserResource($user);
    }

    public function update(Request $request)
    {
        $validData = $request->validate([
            'name' => ['required', 'string', 'max:191'],
            'email' => ['required', 'string', 'email', 'max:191', Rule::unique('users')->ignore(Auth::id())],
            'profile_picture' => [
                'nullable',
                File::image()
                    ->min('1kb')
                    ->max('10mb')
            ],
            'phone' => ['nullable', 'string', 'max:30'],
            'gender' => ['required', 'string', 'in:male,female,non-binary'],
            'device_id' => ['nullable', 'string', 'max:191'],
            'is_tutor' => ['nullable', 'boolean'],
            'location' => ['nullable', 'string', 'max:191'],
            'city' => ['nullable', 'string', 'max:100'],
            'state' => ['nullable', 'string', 'max:100'],
            'state_code' => ['nullable', 'string', 'max:10'],
            'country' => ['nullable', 'string', 'max:100'],
            'country_code' => ['nullable', 'string', 'max:5'],
            'latlng' => ['nullable', 'string', 'max:190'],
        ]);

        if ($request->hasFile('profile_picture')) {
            $validData['profile_picture'] = $request->profile_picture->store('users');
        } else {
            unset($validData['profile_picture']);
        }


        $user = User::findOrFail(Auth::id());
        $user->update($validData);

        event(new Registered($user));

        return new UserResource($user);
    }

    public function changePassword(Request $request)
    {
        $validData = $request->validate([
            'current_password' => ['nullable', 'string', 'min:8'],
            'password' => ['required', Password::defaults()],
        ]);

        $user = User::findOrFail(Auth::id());

        // Incase user password is present in database we need to add following validations
        if (!empty($user->password)) {
            if (empty($validData['current_password'])) {
                throw ValidationException::withMessages([
                    'current_password' => __('Your current password is required for security purpose before you update password'),
                ]);
            }

            if (!Hash::check($validData['current_password'], $user->password)) {
                throw ValidationException::withMessages([
                    'current_password' => __('Invalid current password'),
                ]);
            }
        }

        $user->password = Hash::make($validData['password']);
        $user->save();

        return response()->json(['success' => 'Password has been updated']);
    }

    public function passwordResetRequest(Request $request)
    {
        $request->validate([
            'email' => ['required', 'string', 'email', 'max:191', 'exists:users,email'],
        ]);

        $user = User::where('email', $request->email)->first();
        $user->otp_code = $this->generateNumericToken(config('custom.otp_code_length'));
        $user->otp_code_expires = now()->addMinutes(config('custom.otp_expiry_minutes'));
        $user->save();

        // Send An email to user
        // $user->notify(new PasswordResetRequest($user));
        Mail::to($user->email)->send(new ResetPasswordMail($user->name, $user->otp_code));

        return response()->json(['success' => 'OTP code has been sent to your email']);
    }

    public function passwordReset(Request $request)
    {
        $request->validate([
            'email' => ['required', 'string', 'email', 'max:191', 'exists:users,email'],
            'otp_code' => ['required', 'integer', 'digits:' . config('custom.otp_code_length')],
            'password' => ['nullable', 'confirmed', Password::defaults()],
        ]);

        $user = User::where('email', $request->email)->first();
        if ($user->otp_code == $request->otp_code) {
            if (!empty($user->otp_code_expires) && $user->otp_code_expires->gte(now())) {

                // If request has password than update password else send OTP validation message
                if ($request->filled('password')) {
                    $user->otp_code = null;
                    $user->otp_code_expires = null;
                    $user->password = Hash::make($request->password);
                    $user->save();
                    return response()->json(['success' => 'Password has been updated', 'otp_validated' => true, 'password_reset' => true]);
                }

                return response()->json(['success' => 'OTP is correct', 'otp_validated' => true, 'password_reset' => false]);
            }


        }

        throw ValidationException::withMessages([
            'otp_code' => __('OTP code is invalid'),
        ]);
    }

    /**
     * @param int $length
     * @return string
     * @throws Exception
     */
    private function generateNumericToken(int $length = 4): string
    {
        $i = 0;
        $token = "";

        while ($i < $length) {
            $token .= random_int(1, 9);
            $i++;
        }

        return $token;
    }

    public function notifications(Request $request)
    {
        return NotificationResource::collection(Auth::user()->notifications()->paginate((int) $request->per_page ?? 15));
    }

//     public function tutors(Request $request)
// {
//     $query = User::where('is_tutor', 1)->where('id', '!=', Auth::id());

//     if ($request->filled('search')) {
//         $query->where('name', 'LIKE', $request->search . '%');
//     }

//     if ($request->filled('city')) {
//         $query->where('city', $request->city);
//     }

//     if ($request->filled('country')) {
//         $query->where('country', $request->country);
//     }

//     if ($request->filled('rating')) {
//         $query->where('rating', '>=', $request->rating);
//     }

//     if ($request->filled('students_taught')) {
//         $query->where('students_taught', '>=', $request->students_taught);
//     }

//     if ($request->filled('course_specialization')) {
//         $query->whereHas('courses', function($q) use ($request) {
//             $q->where('name', $request->course_specialization);
//         });
//     }

//     $tutors = $query->get();
//     if ($tutors->isEmpty()) {
//         return response()->json([
//             'message' => 'No data matches the search criteria.'
//         ], 404);
//     }
//     return TutorResource::collection($tutors);
// }

// public function tutors(Request $request)
// {
//     $query = User::where('is_tutor', 1)->where('id', '!=', Auth::id());

//     if ($request->filled('search')) {
//         $query->where('name', 'LIKE', $request->search . '%');
//     }

//     if ($request->filled('city')) {
//         $query->where('city', $request->city);
//     }

//     if ($request->filled('country')) {
//         $query->where('country', $request->country);
//     }

//     if ($request->filled('rating')) {
//         $query->where('rating', '>=', $request->rating);
//     }

//     if ($request->filled('students_taught')) {
//         $query->where('students_taught', '>=', $request->students_taught);
//     }

//     if ($request->filled('course_specialization')) {
//         $query->whereHas('courses', function ($q) use ($request) {
//             $q->where('name', $request->course_specialization);
//         });
//     }

//     // Add filtering for 'days' and 'about' fields if they are provided in the request
//     if ($request->filled('days')) {
//         $query->where('days', 'LIKE', '%' . $request->days . '%');
//     }

//     if ($request->filled('about')) {
//         $query->where('about', 'LIKE', '%' . $request->about . '%');
//     }

//     if ($request->filled('name')) {
//         $query->where('name', 'LIKE', '%' . $request->name . '%');
//     }

//     $tutors = $query->get();

//     if ($tutors->isEmpty()) {
//         return response()->json([
//             'message' => 'No data matches the search criteria.'
//         ], 404);
//     }

//     return TutorResource::collection($tutors);
// }

// public function tutors(Request $request)
// {
//     $query = User::join('tutors', 'users.id', '=', 'tutors.user_id')
//         ->where('is_tutor', 1)
//         ->where('users.id', '!=', Auth::id());

//     if ($request->filled('search')) {
//         $query->where('tutors.name', 'LIKE', $request->search . '%');
//     }

//     if ($request->filled('city')) {
//         $query->where('tutors.city', $request->city);
//     }

//     if ($request->filled('country')) {
//         $query->where('tutors.country', $request->country);
//     }

//     if ($request->filled('rating')) {
//         $query->where('tutors.rating', '>=', $request->rating);
//     }

//     if ($request->filled('students_taught')) {
//         $query->where('tutors.students_taught', '>=', $request->students_taught);
//     }

//     if ($request->filled('course_specialization')) {
//         $query->whereHas('courses', function ($q) use ($request) {
//             $q->where('name', $request->course_specialization);
//         });
//     }

//     if ($request->filled('days')) {
//         $query->where('tutors.days', 'LIKE', '%' . $request->days . '%');
//     }

//     if ($request->filled('about')) {
//         $query->where('tutors.about', 'LIKE', '%' . $request->about . '%');
//     }

//     if ($request->filled('name')) {
//         $query->where('tutors.name', 'LIKE', '%' . $request->name . '%');
//     }

//     $tutors = $query->select('users.*', 'tutors.days', 'tutors.about', 'tutors.package', 'tutors.profile_video')
//         ->get();

//     if ($tutors->isEmpty()) {
//         return response()->json([
//             'message' => 'No data matches the search criteria.'
//         ], 404);
//     }

//     return TutorResource::collection($tutors);
// }

public function tutors(Request $request)
{
    $query = User::join('tutors', 'users.id', '=', 'tutors.user_id')
        ->where('is_tutor', 1)
        ->where('users.id', '!=', Auth::id());

    if ($request->filled('search')) {
        $query->where('tutors.name', 'LIKE', $request->search . '%');
    }

    if ($request->filled('city')) {
        $query->where('tutors.city', $request->city);
    }

    if ($request->filled('country')) {
        $query->where('tutors.country', $request->country);
    }

    if ($request->filled('rating')) {
        $query->where('tutors.rating', '>=', $request->rating);
    }

    if ($request->filled('students_taught')) {
        $query->where('tutors.students_taught', '>=', $request->students_taught);
    }

    if ($request->filled('course_specialization')) {
        $query->whereHas('courses', function ($q) use ($request) {
            $q->where('name', $request->course_specialization);
        });
    }

    if ($request->filled('days')) {
        $query->where('tutors.days', 'LIKE', '%' . $request->days . '%');
    }

    if ($request->filled('about')) {
        $query->where('tutors.about', 'LIKE', '%' . $request->about . '%');
    }

    if ($request->filled('name')) {
        $query->where('tutors.name', 'LIKE', '%' . $request->name . '%');
    }

    // Include tutor_id in the select query
    $tutors = $query->select('users.*', 'tutors.id as tutor_id', 'tutors.days', 'tutors.about', 'tutors.package', 'tutors.profile_video')
        ->get();

    if ($tutors->isEmpty()) {
        return response()->json([
            'message' => 'No data matches the search criteria.'
        ], 404);
    }

    return TutorResource::collection($tutors);
}

public function getUsers()
{
    // Fetch users with specific columns
    $users = User::select('id', 'name', 'profile_picture')->get();

    // Return response as JSON
    return response()->json([
        'success' => true,
        'data' => $users
    ], 200);
}
}
